<?php

// set_site_transient('update_plugins', null);

if (!class_exists('ncore_WpPluginUpdateChecker')) {
    class ncore_WpPluginUpdateChecker
    {
        private $plugin_name = '';
        private $plugin_file = '';
        private $query_url = '';
        private $data = false;

        private $plugin_data = false;

        public function __construct($plugin_name, $plugin_file, $query_url)
        {
            $this->plugin_name = $plugin_name;
            $this->plugin_file = $plugin_file;
            $this->query_url = $query_url;
        }
        public static function init($plugin_name, $plugin_file, $query_url)
        {
            $instance = new ncore_WpPluginUpdateChecker($plugin_name, $plugin_file, $query_url);
            /**
             * @psalm-suppress HookNotFound
             * with WP 5.5 this should be a core Hook
             */
            add_filter('pre_set_site_transient_update_plugins', [$instance, 'updateCheck']);
            add_filter('plugins_api', [$instance, 'pluginsApi'], 10, 3);
        }

        public function pluginsApi($def, $action, $args)
        {
            $plugin = $this->retrieve($args, 'slug');

            if ('plugin_information' !== $action) {
                return $def;
            }

            $is_for_me = $plugin == $this->plugin_name;
            if (!$is_for_me) {
                return $def;
            }

            $data = $this->queryData();

            if ($data) {
                $info_url = $this->retrieve($data, 'info_url');

                $result = new stdClass();

                $result->name = $this->plugin_name;
                $result->homepage = $info_url;
                $result->version = $this->retrieve($data, 'version');
                $result->description = $this->retrieve($data, 'description', $this->pluginData('description'));
                $result->author = $this->retrieve($data, 'author', $this->pluginData('author'));
                $result->authorURI = $info_url;

                $result->slug = $this->plugin_name;
                $result->date = $this->retrieve($data, 'release_date');
                $result->tested = $this->retrieve($data, 'max_wp_version', (string) get_bloginfo('version'));
                $result->requires = $this->retrieve($data, 'min_wp_version', (string) '4.0.0');
                $result->external = '';
                $result->package = $this->retrieve($data, 'download_url');
                $result->file_name = $this->plugin_name.'.zip';
                $result->downloaded = $this->retrieve($data, 'download_counter');
                $result->sections = (array) $this->retrieve($data, 'sections');

                if (empty($result->sections['description'])) {
                    $result->sections['description'] = $result->description;
                }
            } else {
                $msg = 'Error connecting to the upgrade server - please try again later.';
                $result = new WP_Error('plugins_api_failed', $msg);
            }

            return $result;
        }

        public function updateCheck($checked_data)
        {
            $data = $this->queryData();

            $current_version = $this->pluginData('version');

            $new_version = $this->retrieve($data, 'version');

            $is_new = $new_version > $current_version;
            if (!$is_new) {
                return $checked_data;
            }

            $result = new stdClass();

            $result->slug = $this->plugin_name;
            $result->new_version = $new_version;
            $result->url = $this->retrieve($data, 'info_url');
            $result->package = $this->retrieve($data, 'download_url');
            $result->icons = (array) $this->retrieve($data, 'icons', []);
            $result->tested = $this->retrieve($data, 'max_wp_version', (string) get_bloginfo('version'));

            $checked_data->response[$this->plugin_file] = $result;

            return $checked_data;
        }

        private function retrieve($array, $key, $default = '')
        {
            if (is_array($array)) {
                return empty($array[$key])
                       ? $default
                       : $array[$key];
            }
            if (is_object($array)) {
                return empty($array->$key)
                       ? $default
                       : $array->$key;
            }

            return $default;
        }

        private function pluginData($key, $default = '')
        {
            if (!$this->plugin_data) {
                $file = dirname(__DIR__).'/'.$this->plugin_file;
                /**
                 * @psalm-suppress NullArgument
                 * @psalm-suppress InvalidArgument
                 */
                $contents = file_get_contents($file, false, null, 0, 1500);

                $plugin = [];
                $mtx = [];

                preg_match_all('/[^a-z0-9]+((?:[a-z0-9]{2,25})(?:\ ?[a-z0-9]{2,25})?(?:\ ?[a-z0-9]{2,25})?)\:[\s\t]*(.+)/i', $contents, $mtx, PREG_SET_ORDER);
                foreach ($mtx as $m) {
                    $plugin[trim(str_replace(' ', '-', strtolower($m[1])))] = str_replace(["\r", "\n", "\t"], '', trim($m[2]));
                }
                unset($plugin['http']);

                $this->plugin_data = $plugin;
            }

            return $this->retrieve($this->plugin_data, $key, $default);
        }

        private function queryData($force_reload = false)
        {
            if (!empty($this->data) && !$force_reload) {
                return $this->data;
            }

            $request = [
                'action' => 'update_info',
                'site' => site_url(),
                'wp_version' => get_bloginfo('version'),
                'package' => $this->plugin_name,
                'version' => $this->pluginData('version'),
                'php_version' => phpversion(),
                'locale' => get_locale(),
            ];

            if (version_compare(PHP_VERSION, '8.0.0', '>=')) {
                $is_debug = str_contains('https://www.digistore24.com', 'SITEURL');
            } else {
                $is_debug = strpos('https://www.digistore24.com', 'SITEURL') !== false;
            }
            $url = $is_debug
                 ? str_replace('https://www.digistore24.com', 'http://digistore.local', $this->query_url)
                 : $this->query_url;

            $url .= '/package_info?'.http_build_query($request, '', '&');

            $response = wp_remote_get($url);

            $this->data = json_decode($this->retrieve($response, 'body'));

            if (empty($this->data)) {
                $this->data = false;
            }

            return $this->data;
        }
    } // class
} // if class_exists
