<?php

/*
Plugin Name: Digistore24
Version: 2.54
Author: Christian Neise
Author URI: https://www.digistore24.com
Description: Use this with Digistore24, if you want to reward your affiliates for sending visitors to your blog and/or if you want handle upsells.
Plugin URI: https://www.digistore24.com
Text Domain: digistore_meta
Domain Path: /


LICENSE AGREEMENT / TERMS OF USAGE

You may use, modify, use the modified version of this file for the purpose of using
any webshop, billing system, web page, sales page or any other page with the
purpose of selling digital or physical goods with the Digistore24 Inc..

THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

//
// Link template for the bloglink generator
//
// If you want to direct the visitors to a sub page, replace '/' by the path to the page,
// e.g. by '/some-sales-page'
define('DIGISTORE_BLOG_BASE_LINK', rtrim(site_url(), '/').'/');

define('AFFVAR', 'DIGISTORE24ID');

if (!defined('DIGISTORE_SITE_URL')) {
    define('DIGISTORE_SITE_URL', 'DIGISTORE_SITE_URL');
}

//
// No need for changes below this line
//

class DigiStore
{
    const DIGISTORE_API_KEY = '1149-IuEtCUavMdtxPW00QUtTNMJBuOQ69GiO7yijSHUV';

    const DOC_URL = 'https://help.digistore24.com/hc/de/articles/23658731150737-Digistore24-WordPress-Plugin-installieren';

    const DEBUG = false;

    const ALLOWED_YES_QUERY_PARAMS = ['product', 'payplan', 'qty', 'template'];

    const GET_PARAM_FIRST_NAME = ['digistore_first_name', 'buyer_first_name', 'first_name', 'fn', 'f'];
    const GET_PARAM_LAST_NAME = ['digistore_last_name', 'buyer_last_name', 'last_name', 'ln', 'l'];
    const GET_PARAM_EMAIL = ['buyer_email', 'email', 'e'];

    private $product_id = 'YOUR_PRODUCT_ID'; // seperate multiple ids by comma
    private $get_param_affiliate = 'aff';
    private $get_param_campaignkey = 'cam';

    private $thankyou_page_key = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

    private $upsell_session_id = false;
    private $upsell_first_name = false;
    private $upsell_last_name = false;
    private $upsell_email = false;
    private $upsell_initial_product_id = false;

    private $affiliate = false;
    private $campaignkey = false;

    private $digistore_input_id = 1;

    //
    // private
    //

    private $admin_option_name = 'DigiStoreOptions';
    private $tracking_code_rendered = false;

    public function __construct()
    {
        $this->upsellSessionId();
        $this->detectAffiliateFromGetParams();
    }

    public static function getInstance()
    {
        static $instance;
        if (!isset($instance)) {
            $instance = new self();
        }

        return $instance;
    }

    public function adminPage()
    {
        $options = $this->getAdminOptions();

        $errors = [];

        $do_save = isset($_POST['digimember_update']);

        if ($do_save) {
            $value_dirty = $this->requestvar($this->postname('custom_domain'));
            $options['custom_domain'] = $this->washUrl($value_dirty);

            foreach ($this->adminOptionLabels() as $key => $label) {
                $postname = $this->postname($key);

                $value_dirty = $this->requestvar($postname);
                $value = $this->washText($value_dirty);

                $options[$key] = $value;

                if (!$value) {
                    $errors[] = $this->_('%s is required.', $label);
                }
            }

            if (!$errors) {
                $this->storeAdminOptions($options);
            }
        }

        $hl_main = $this->_('[OWNER] Plugin');
        $hl_promocode = $this->_('Promocode Trackingpixel');
        $hl_upsell = $this->_('Upsells with [OWNER]');
        $hl_custom_domain = $this->_('Custom domain configuration');

        $hl_link_generator = $this->_('Link generators');

        $hl_promo_link = $this->_('Promolink');
        $label_save = $this->_('Update options');

        $action = $_SERVER['REQUEST_URI'];

        $txt_main = $this->renderGeneralExplanation();
        $txt_custom_domain = $this->renderCustomDomainExplanation();
        $txt_promocode = $this->renderPromocodeExplanation();
        $txt_upsell = $this->renderUpsellExplanation();

        $txt_promo_link_generator = $this->_('Add %s to your wordpress page to create a [OWNER] promo link generator. Your affiliates your the promolink to direct visitors to your sales page. ', '<span class="digistore_shortcode">[digistore_promolink]</span>');

        $txt_blog_link_syntax_tmpl = $this->_('Generates links to [TARGET]');
        $txt_blog_link_syntax_tmpl = str_replace('[TARGET]', '<span class="digistore_shortcode">%s</span>', $txt_blog_link_syntax_tmpl);

        $txt_promolink_syntax_1 = $this->_(' Generates the affiliate\'s promolink for the (first) product id you entered above.');

        $exp_promolink_url = 'http://mein-blog.de/#aff=AFFILIATE';
        //str_replace('PRODUCT_ID', $this->_('PRODUCT-ID'), $this->getDigistorePromolink());
        $txt_promolink_syntax_3 = sprintf($txt_blog_link_syntax_tmpl, $exp_promolink_url);

        $txt_promolink_syntax_3a = $this->_('Hides the promolink output field. Used only with %s.', '<span class="digistore_shortcode">[digimember_promolink_code]</span>');

        $txt_promolink_syntax_4 = $this->_('Do not encode html characters. Try this, if the html code looks like %s', '&amp;lt;a href="..."/&amp;gt;&amp;lt...');
        $txt_promolink_syntax_5 = $this->_('Enclose html in textarea of size %s x %s. You may enter your own size.', 60, 5);
        $txt_promolink_syntax_6 = $this->_('Do not remove line breaks and paragraphs. If you use this option, you may want to use line <p> and <br> in your html code.');

        $register_blog_domain_hint_hl = $this->_('Important note: Register your blog!');
        $register_blog_domain_hint_txt = str_replace('|', '</p><p>', $this->_('Only required, if you do <b>not</b> use your blog domain in salespages:|To prevent fraud, you need to register your blog domain with Digistore24, if it\'s not entered as a salespage in Digistore24. Otherwise the affiliate links above will not work.|To register your blog domain, visit  Digistore, there Vendor view: Settings - Promocode for salespage (url: https://www.digistore24-team.com).|Domains used in salespages of Digistore24 product need <b>not</b> to be registered.', '<a href="https://www.digistore24.com">https://www.digistore24.com</a>', '<span class="digistore_shortcode">'.$this->getDigistorePromolink().'</span>'));

        $register_blog_domain_hint_ref = $this->_('Please take a look at the text of <em>%s</em> above!', '"'.$register_blog_domain_hint_hl.'"');

        $hl_preview = $this->_('Preview');
        $hl_usage = $this->_('Usage');
        $hl_example = $this->_('Example');
        $hl_bannercode = $this->_('Advertising material');

        $txt_bannercode_1 = $this->_('The [OWNER] plugin can automatically create bannercodes, emails or so generated with the affiliate\'s [OWNER_ID].');

        //$txt_example = $this->_('To view the result of this example, enter your [OWNER_ID] under %s above.');
        $example_banner = htmlspecialchars($this->_('<a href="%s"><img src="http://your-domain.com/some-image.gif" /></a>', '[digistore_link]'));

        $example_banner_promolink = $this->renderPromoLinkCode([], $example_banner, $skip_affiliate_filter = true);

        $txt_promolink_syntax_note = $this->_('You may alo mix parameters, e.g.: %s', '<span class="digistore_shortcode">[digistore_promolink_code textarea=60x40 encode=off]</span>');

        $url = self::DOC_URL;

        $hl_doc = $this->_('Documentation');
        $txt_doc = str_replace('<a>', "<a href=\"$url\" target=\"_blank\">", $this->_('For more information on the [OWNER] Wordpress plugin, <a>click here</a>.'));

        $year = date('Y');
        $copyright = "<p style=\"margin-top: 5em;\"><hr />Copyright &copy; $year by <a href='https://www.digistore24.com'>Digistore24 Inc.</a>";

        echo "

             <div class='wrap'  style='max-width: 60em;'>
             <h1>$hl_main</h1>

             $txt_main

             <form method='post' action='$action'>

        ";

        echo "
            <h2>1. $hl_promocode</h2>

             $txt_promocode
";

        if ($errors) {
            echo "<div class='error' style='width: 800px;'><p><strong>";
            echo implode('</strong></p><p><strong>', $errors);
            echo '</strong></p></div>';
        } elseif ($do_save) {
            echo "<div class='updated' style='width: 800px;'><p><strong>";
            echo $this->_('Your changes have been saved.');
            echo '</strong></p></div>';
        }

        echo "
            <table class='digistore_form_table'>
            <tbody>
";

        foreach ($this->adminOptionLabels() as $key => $label) {
            $value = $options[$key];
            $postname = $this->postname($key);

            echo "
            <tr>
                <th>$label</th>
                <td><input type='text' name='$postname' size=\"15\" value=\"$value\" /></td>
            </tr>
";

            $hint = $this->adminOptionHint($key);
            if ($hint) {
                echo "<tr class=\"digistore_hint\"><td></td><td class=\"digistore_hint\">$hint</td></tr>";
            }
        }

        $colon = $this->_(':');

        echo "</tbody>
               </table>

               <h3>$register_blog_domain_hint_hl</h3>

               <p>$register_blog_domain_hint_txt</p>

               <div class='submit'>
                <input type='submit' name='digimember_update' value='$label_save' class='button-primary' /></div>

            </form>

            <h2>2. $hl_upsell</h2>

            $txt_upsell

            <h2>4. $hl_link_generator</h2>

            <strong>$register_blog_domain_hint_ref</strong>

            <h3>3.a) $hl_promo_link$colon <span class=\"digistore_shortcode\">[digistore_promolink]</span></h3>

            $txt_promo_link_generator

            <h3>$hl_usage</h3>
            <table>
            <tbody>
                <tr>
                    <td class=\"digistore_shortcode\">[digistore_promolink]</td>
                    <td>$txt_promolink_syntax_1</td>
                </tr>
                <tr>
                    <td class=\"digistore_shortcode\">[digistore_promolink url=$exp_promolink_url]</td>
                    <td>$txt_promolink_syntax_3</td>
                </tr>
                <tr>
                    <td class=\"digistore_shortcode\">[digistore_promolink url=none]</td>
                    <td>$txt_promolink_syntax_3a</td>
                </tr>

            </tbody>
            </table>

            <h3>$hl_preview</h3>

            ".$this->renderPromoLinkGenerator()."

            <h3>3.b) $hl_bannercode</h3>
            <p>$txt_bannercode_1</p>

            <h3>$hl_usage</h3>

            <h4>$hl_example</h3>

            <div class=\"digistore_code\">

            <p><span class=\"digistore_shortcode\">[digistore_promolink]</span></p>

            <span class=\"digistore_shortcode\">[digistore_promolink_code]</span>
            <p>$example_banner</p>
            <span class=\"digistore_shortcode\">[/digistore_promolink_code]</span>
            </div>

            <table>
            <tr>
                <td class=\"digistore_shortcode\">[digistore_promolink_code encode=off]</td>
                <td>$txt_promolink_syntax_4</td>
            </tr>
            <tr>
                <td class=\"digistore_shortcode\">[digistore_promolink_code textarea=60x5]</td>
                <td>$txt_promolink_syntax_5</td>
            </tr>
            <tr>
                <td class=\"digistore_shortcode\">[digistore_promolink_code keep_p_and_br=on]</td>
                <td>$txt_promolink_syntax_6</td>
            </tr>
            </table>

            <p>$txt_promolink_syntax_note</p>

            <h3>$hl_preview</h3>

            <p>".$this->renderPromoLinkGenerator()."</p>
            <p>$example_banner_promolink</p>


             <h2>4. $hl_custom_domain</h2>

             $txt_custom_domain
            <table class='digistore_form_table'>
                <tbody>
                    <tr>
                        <th>{$this->_('Custom Domain')}</th>
                        <td><input type='url' name='{$this->postname('custom_domain')}' size=\"15\" value=\"{$options['custom_domain']}\" /></td>
                    </tr>
                </tbody>
            </table>
            <div class='submit'>
                <input type='submit' name='digimember_update' value='{$label_save}' class='button-primary' />
            </div>

            <h3>$hl_doc</h3>
            <p>$txt_doc</p>

            <p>$copyright</p>
        </div>
";

        return '';
    }

    /**
     * Validates the plugin configuration and shows error messages if needed
     * Called via WordPress admin_notices hook
     *
     * @psalm-used-by admin_notices (WordPress hook)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function validateConfig()
    {
        if (!empty($_POST)) {
            return;
        }

        $error_msgs = [];

        $product_id = $this->getFirstProductId();
        $is_valid = is_numeric($product_id) && $product_id >= 1;
        if (!$is_valid) {
            $error_msgs[] = $this->_('Please enter a valid product id on page <em>Settings - %s</em>', 'Digistore24');
        }

        if (!$error_msgs) {
            return;
        }

        echo "<div id='message' class='error'><p><strong>Digistore24: "
            .implode('</strong></p><p><strong>', $error_msgs)
            .'</strong></p></div>';
    }

    /**
     * Renders the signup URL for DigiStore24
     * Called via digistore_signup_url shortcode
     *
     * @psalm-used-by digistore_signup_url (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderSignupUrl()
    {
        return $this->_signUpUrl();
    }

    /**
     * Renders the current affiliate ID
     * Called via digistore_affiliate shortcode
     *
     * @psalm-used-by digistore_affiliate (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderAffiliate()
    {
        return $this->affiliate;
    }

    /**
     * Renders the current campaign key
     * Called via digistore_campaignkey shortcode
     *
     * @psalm-used-by digistore_campaignkey (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderCampaignkey()
    {
        return $this->campaignkey;
    }

    /**
     * Renders promo link code with customizable HTML output
     * Called via digistore_promolink_code shortcode
     *
     * @psalm-used-by digistore_promolink_code (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderPromoLinkCode($atttributes, $content, $skip_affiliate_filter = false)
    {
        $content = $this->preparePromoHtmlCode($atttributes, $content);

        $find = ['[digistore_link]', '[digistore_id]'];
        $repl = ['PROMOLINK',        AFFVAR];
        $parsed = str_replace($find, $repl, $content);

        $template = $parsed;

        if (true !== $skip_affiliate_filter) {
            $preset_affiliate = $this->_getPresetGeneratorAffiliate();
            if ($preset_affiliate) {
                $find = ['PRODUCT_ID', AFFVAR];
                $repl = [$this->getFirstProductId(), $preset_affiliate];
                $promolink = str_replace($find, $repl, $this->getDigistorePromolink());

                $find = [];
                $repl = [];

                $find[] = AFFVAR;
                $repl[] = $preset_affiliate;

                $find[] = 'PROMOLINK';
                $repl[] = $promolink;

                $parsed = str_replace($find, $repl, $parsed);
            }
        }

        return "<div class=\"digistore_rendered_code\"><div class=\"digistore_content\">$parsed</div><div class=\"digistore_template\" style=\"display: none;\">$template</div></div>";
    }

    /**
     * Filters content to add upsell session IDs and parse shortcodes
     * Called via WordPress the_content hook
     *
     * @psalm-used-by the_content (WordPress hook)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function contentFilter($content)
    {
        $content = $this->maybeAddUpsellSessionId($content);

        $content = $this->finallyParseShortcodes($content);

        // always call digistoreUpsell() to make sure upsell links generated via wp plugin get special upsell handling
        if ($this->upsell_session_id) {
            $content .= '<script type="text/javascript">
                window._ds24 = !window._ds24 ? {q:[],e:function(){}} : window._ds24;
                window._ds24.q.push([\'digistoreUpsell\']);
                window._ds24.e();
        </script>';
        }

        return $content;
    }

    /**
     * Adds DigiStore admin menu page
     * Called via WordPress admin_menu hook
     *
     * @psalm-used-by admin_menu (WordPress hook)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function admiMenu()
    {
        add_options_page('digistore', 'Digistore24', 'manage_options', basename(__FILE__), [
            $this,
            'adminPage',
        ]);
    }

    /**
     * Initializes and enqueues JavaScript files and promocode
     * Called via WordPress wp_enqueue_scripts hook
     *
     * @psalm-used-by wp_enqueue_scripts (WordPress hook)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function initScripts()
    {
        wp_enqueue_script('jquery');

        $url = plugins_url('digistore/digistore.js', 'digistore');

        wp_enqueue_script('digistore-wp', $url, ['jquery']);

        wp_register_script('digistore', 'https://www.digistore24-scripts.com/service/digistore.js', [], '2.52wp', false);

        if ($this->hasPromoCode()) {
            wp_enqueue_script('digistore');
            $promocode = $this->getJsPromoCode();
            wp_add_inline_script('digistore', $promocode);
        }
    }

    /**
     * Adds settings link to plugin actions in WordPress admin
     * Called via WordPress plugin_action_links hook
     *
     * @psalm-used-by plugin_action_links (WordPress hook)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function addSettingsLink($links)
    {
        $label = $this->_('Settings');

        $url = 'options-general.php?page=digistore.php';

        $settings_link = "<a href='$url'>$label</a>";
        array_unshift($links, $settings_link);

        return $links;
    }

    /**
     * Renders the upsell "yes" URL with optional parameters
     * Called via digistore_yes_url shortcode
     *
     * @psalm-used-by digistore_yes_url (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderUpsellYesUrl($atts = [])
    {
        $atts = (array) $atts;
        $allowedYesQueryParams = self::ALLOWED_YES_QUERY_PARAMS;
        $query = array_filter(
            $atts,
            function ($key) use ($allowedYesQueryParams) {
                return in_array($key, $allowedYesQueryParams, true);
            },
            ARRAY_FILTER_USE_KEY
        );
        $query = array_map('intval', $query);

        $queryString = build_query($query);

        return sprintf('%s%s/yes/%s',
            $this->getUpsellUrl(),
            $this->upsellSessionId(),
            $queryString ? '?'.$queryString : $queryString
        );
    }

    /**
     * Renders the upsell "no" URL
     * Called via digistore_no_url shortcode
     *
     * @psalm-used-by digistore_no_url (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderUpsellNoUrl()
    {
        return $this->getUpsellUrl().$this->upsellSessionId().'/no/';
    }

    /**
     * Renders the base upsell URL
     * Called via digistore_upsell_url shortcode
     *
     * @psalm-used-by digistore_upsell_url (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderUpsellUrl()
    {
        return $this->getUpsellUrl().$this->upsellSessionId();
    }

    /**
     * Renders the customer's first name for upsell personalization
     * Called via digistore_first_name shortcode
     *
     * @psalm-used-by digistore_first_name (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderUpsellFirstName()
    {
        $this->upsellSessionId();

        return $this->upsell_first_name
            ? $this->upsell_first_name
            : $this->renderData('first_name');
    }

    /**
     * Renders the customer's last name for upsell personalization
     * Called via digistore_last_name shortcode
     *
     * @psalm-used-by digistore_last_name (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderUpsellLastName()
    {
        $this->upsellSessionId();

        return $this->upsell_last_name
            ? $this->upsell_last_name
            : $this->renderData('last_name');
    }

    /**
     * Renders the customer's email for upsell personalization
     * Called via digistore_email shortcode
     *
     * @psalm-used-by digistore_email (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderUpsellEmail()
    {
        $this->upsellSessionId();

        return $this->upsell_email
            ? $this->upsell_email
            : $this->renderData('email');
    }

    /**
     * Renders customer data based on parameter key
     * Called via digistore shortcode
     *
     * @psalm-used-by digistore (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderData($args)
    {
        $get_param_names = [
            'first_name' => self::GET_PARAM_FIRST_NAME,
            'last_name' => self::GET_PARAM_LAST_NAME,
            'email' => self::GET_PARAM_EMAIL,
        ];

        $key = strtolower(trim(is_string($args) ? $args : $this->retrieve($args, 0), ' :'));
        if (!$key) {
            $key = strtolower(trim($this->retrieve($args, 1), ' :'));
        }

        if (isset($get_param_names[$key])) {
            $get_param = $get_param_names[$key];
        } else {
            foreach ($get_param_names as $k => $list) {
                if (in_array($key, $list)) {
                    $get_param = $list;
                    $key = $k;
                    break;
                }
            }
            if (empty($get_param)) {
                return '';
            }
        }

        $result_string = $this->_get_param($get_param);
        if ($result_string) {
            return $result_string;
        }

        if (!$result_string) {
            switch ($key) {
                case 'email':
                    return $this->upsell_email;
                case 'first_name':
                    return $this->upsell_first_name;
                case 'last_name':
                    return $this->upsell_last_name;
            }
        }

        return '';
    }

    /**
     * Renders the initial product ID from upsell session
     * Called via digistore_initial_product_id shortcode
     *
     * @psalm-used-by digistore_initial_product_id (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderUpsellInitialProductId()
    {
        $this->upsellSessionId();

        return $this->upsell_initial_product_id;
    }

    /**
     * Renders promo link input field
     * Called via digistore_promolink_input shortcode
     *
     * @psalm-used-by digistore_promolink_input (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderPromoLinkInput()
    {
        return $this->renderDs24IdInput('digistore_promolink');
    }

    /**
     * Renders blog link input field
     * Called via digistore_bloglink_input shortcode
     *
     * @psalm-used-by digistore_bloglink_input (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderBlogLinkInput()
    {
        return $this->renderDs24IdInput('digistore_bloglink');
    }

    /**
     * Renders promo link generator form
     * Called via digistore_promolink shortcode
     *
     * @psalm-used-by digistore_promolink (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderPromoLinkGenerator($args = [])
    {
        $promo_link = $this->promoLink($args);

        $container_css = $this->retrieve($args, 'container');

        return $this->renderLinkGenerator($promo_link, 'digistore_promolink', $have_signup_link = true, $container_css);
    }

    /**
     * Renders blog link generator form
     * Called via digistore_bloglink shortcode
     *
     * @psalm-used-by digistore_bloglink (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderBlogLinkGenerator($args = [])
    {
        $promo_link = $this->blogLink($args);

        $container_css = $this->retrieve($args, 'container');

        return $this->renderLinkGenerator($promo_link, 'digistore_bloglink', $have_signup_link = true, $container_css);
    }

    /**
     * Renders viewport meta tag and basic CSS for cart checkout
     * Called via WordPress wp_head hook in renderDigistoreCartCheckout()
     *
     * @psalm-used-by wp_head (WordPress hook)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderViewportMeta()
    {
        echo '<meta name="viewport" content="width=device-width, initial-scale=1.0"
<style> body { margin:0; } </style>
';
    }

    /**
     * Renders DigiStore cart checkout iframe
     * Called via digistore_cart_checkout shortcode
     *
     * @psalm-used-by digistore_cart_checkout (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     * @psalm-suppress PossiblyUnusedParam
     */
    public function renderDigistoreCartCheckout($args = [])
    {
        add_action('wp_head', [$this, 'renderViewportMeta'], 10,0);

        $site_url = 'https://www.digistore24.com';

        return "
<script src=\"$site_url/service/js/orderform_widget.js\"></script>
<iframe class=\"ds24_payIFrame\" style=\"overflow: hidden; width: 100%; height: 100%; border: none; margin:0; padding: 0; background: transparent;\" src=\"$site_url/checkout?iframe=1\" sandbox='allow-top-navigation allow-modals allow-scripts allow-forms allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts'></iframe>
";
    }

    /**
     * Renders DigiStore cart JavaScript
     * Called via digistore_cart shortcode
     *
     * @psalm-used-by digistore_cart (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderDigistoreCartJs($args = [])
    {
        $options = '';

        if (!$args) {
            // empty
        } elseif (is_array($args)) {
            foreach ($args as $k => $v) {
                if ($options) {
                    $options .= ' ';
                }

                if (is_numeric($k)) {
                    $options .= $v;
                    continue;
                }

                $options .= $k;
                if (!empty($v)) {
                    $options .= "=$v";
                }
            }
        } elseif (is_string($args)) {
            $options = $args;
        }

        wp_enqueue_script('digistore');

        $html = "<script>
        window._ds24 = !window._ds24 ? {q:[],e:function(){}} : window._ds24;
        window._ds24.q.push(['digistoreCart', '$options']);
        window._ds24.e();
</script>";

        return $html;
    }

    private function promoLink($args = [])
    {
        $have_no_promolink = isset($args['url']) && (!$args['url'] || 'none' == $args['url']);
        if ($have_no_promolink) {
            return '';
        }

        $url = trim($this->retrieve($args, 'url'));

        if (!$url) {
            $is_href = isset($args['href']);
            if ($is_href) {
                $url = str_replace('.affiliate.', '.AFFILIATE.', $args['href']);
            }
        }

        if (!$url) {
            $url = $this->getDigistorePromolink();
        }

        $product_id = $this->getFirstProductId();

        $promo_link = str_replace('PRODUCT_ID', $product_id, $url);

        return $this->sanitizeGeneratorUrl($promo_link);
    }

    private function blogLink($args = [])
    {
        $have_no_promolink = isset($args['url']) && (!$args['url'] || 'none' == $args['url']);
        if ($have_no_promolink) {
            return '';
        }

        $options = $this->getAdminOptions();

        $get_param_affiliate = $options['get_param_affiliate'];

        $url = trim($this->retrieve($args, 'url'));

        $is_full_url = (bool) parse_url($url, PHP_URL_SCHEME);

        if ($is_full_url) {
            $promo_link = "$url#$get_param_affiliate=".AFFVAR;
        } else {
            $url = ltrim($url, '/');
            $promo_link = DIGISTORE_BLOG_BASE_LINK."$url#$get_param_affiliate=".AFFVAR;
        }

        $promo_link = $this->sanitizeGeneratorUrl($promo_link);

        return $promo_link;
    }

    private function getBaseUrl()
    {
        $url = 'https://www.checkout-ds24.com';

        $options = $this->getAdminOptions();
        if ($options['custom_domain']) {
            $url = $options['custom_domain'];
        }

        /**
         * Filters the base URL used for DigiStore24 operations.
         *
         * @param string $url The base URL, either the default checkout URL or custom domain.
         */
        $url = apply_filters('ds24_base_url', $url);

        return $url;
    }

    private function getUpsellUrl()
    {
        return $this->getBaseUrl().'/answer/';
    }

    protected function getDigistorePromolink(): string
    {
        $options = $this->getAdminOptions();

        return sprintf('%s?%s=%s&%s=%s',
            DIGISTORE_BLOG_BASE_LINK,
            $options['get_param_affiliate'],
            $this->affiliate ?: AFFVAR,
            $options['get_param_campaignkey'],
            $this->campaignkey
        );
    }

    private function sanitizeGeneratorUrl($promolink)
    {
        $find = ['[digistore_id]', 'digistore_id'];
        $repl = [AFFVAR,          AFFVAR];

        return str_replace($find, $repl, $promolink);
    }

    private function renderDs24IdInput($prefix)
    {
        return $this->renderLinkGenerator($promolink = false, $prefix, $have_signup_link = false);
    }

    private function renderLinkGenerator($promolink, $prefix, $have_signup_link = true, $container_css = '')
    {
        $promolink = $this->purgeQuotes($promolink);

        $html_id = 'db24_'.$this->digistore_input_id++;

        $signup_link = $this->_signUpUrl();

        $label_digistore_id = $this->_('Your [OWNER_ID]:');
        $label_promolink = $this->_('Your Promolink:');
        $label_enter = $this->_('Enter your [OWNER_ID] above.');

        $size = $promolink
            ? max(30, 2 + strlen($label_enter))
            : 30;

        $input_digistore_id = "<input id=\"$html_id\" size=\"$size\" type=\"text\" class=\"digistore_affiliate_input\"  />";
        $input_promolink = $promolink
            ? "<input size=\"$size\" id=\"digistore_output_$html_id\" type=\"text\" readonly=\"readonly\" class=\"digistore_affiliate_output digistore_focus\" value=\"$label_enter\" />"
            ."<input type=\"hidden\" id=\"digistore_promolink_$html_id\" value=\"$promolink\" />"
            : '';

        $signup_hint = $have_signup_link
            ? $this->_('No [OWNER_ID]?')
            .' '
            ."<a href=\"$signup_link\" target=\"_blank\">"
            .$this->_('Sign up now!')
            .'</a>'
            : '';

        static $js_common_included;

        $js = '';
        $html = '';

        $AFFVAR = AFFVAR;

        if (empty($js_common_included)) {
            $js_common_included = empty($js_common_included)
                ? 1
                : $js_common_included + 1;

            $signup_click_here = $signup_link
                ? " <a style='white-space: nowrap;' href='$signup_link' target='_blank'>"
                .$this->_('Join now!')
                .'</a>'
                : '';

            $singup_msg_span_id = 'ds_signup_'.$js_common_included.time();
            $html .= "<span id='$singup_msg_span_id' style='display:none;'>$signup_click_here</span>";

            $options = $this->getAdminOptions();

            $product_ids = $options['product_id'];
            $apikey = self::DIGISTORE_API_KEY;
            $lang = get_locale();

            $js .= "

function digistore_set_affiliate( affiliate, is_preset_default_affiliate )
{
    if (is_preset_default_affiliate) {
        digistore_preset_affiliate = affiliate.toLowerCase();
    }

    jQuery('.digistore_affiliate_input').val(affiliate);

    affiliate = affiliate.toLowerCase();

    var first_promolink = '';

    jQuery.each( jQuery('.digistore_affiliate_output'), function(index,element)
        {
            var promolink = '';

            if (affiliate)
            {
                var id = element.id.replace( /digistore_output_/, 'digistore_promolink_' );

                promolink = jQuery( '#'+id ).val();
                if (!promolink)
                    promolink = '';

                promolink=promolink.replaceAll( 'AFFILIATE', affiliate );
                promolink=promolink.replaceAll( '$AFFVAR', affiliate );

                if (!first_promolink)
                    first_promolink = promolink;
            }
            else
            {
                promolink = \"$label_enter\";
            }

            jQuery( element ).val(promolink);
        }
    );

    jQuery.each( jQuery('.digistore_rendered_code'), function(index,element)
        {
            var html = jQuery( element ).children( 'div.digistore_template' ).html();

            if (affiliate)
            {
                html = html.replace( /AFFILIATE/g, affiliate );
                html = html.replace( /$AFFVAR/g, affiliate );
                html = html.replace( /PROMOLINK/g, first_promolink );
            }

            jQuery( element ).children( 'div.digistore_content' ).html( html );
        }
    );

";
            if ($container_css) {
                $js .= "

    jQuery.each( jQuery('.$container_css'), function(index,element)
        {
            var html = jQuery( element ).html();

            html = html.replace( /a href=\".*?\"/g, 'a href=\"'+first_promolink+'\"' );

            jQuery( element ).html( html );
        }
    );
";
            }

            $js .= "

    if (!affiliate)
    {
        return;
    }

   var exec = function() { ds24wp_api( digistore_set_affiliate_callback, '$apikey', '$lang', 'validateAffiliate', affiliate, '$product_ids' ); };

"

                ." if (typeof digistore_affiliation_cb_handle != 'undefined')
        if (digistore_affiliation_cb_handle)
        {
            clearTimeout( digistore_affiliation_cb_handle );
            digistore_affiliation_cb_handle = false;
        }

    if (is_preset_default_affiliate)
    {
        exec();
    }
    else
    {
        digistore_affiliation_cb_handle = window.setTimeout( exec, 500 );
    }
}

function digistore_set_affiliate_callback( data )
{
    try
    {

        var url      = data.invite_url;
        var status   = data.affiliation_status;
        var msg      = data.affiliation_status_msg;
        var aff_name = data.affiliate_name;

        var is_ok     = data.have_affiliation == 'Y';

        if (typeof this.orig_status_hint == 'undefined')
        {
            this.orig_status_hint = jQuery('.digistore_affiliation_status_hint').html();
        }

        if (is_ok)
        {
            jQuery('.digistore_affiliation_status_hint').removeClass( 'digistore_affiliation_status_info' )
                                                        .removeClass( 'digistore_affiliation_status_error' )
                                                        .addClass( 'digistore_affiliation_status_success' )
                                                        .html( msg );
        }
        else if ( typeof digistore_preset_affiliate != 'undefined' && digistore_preset_affiliate && aff_name == digistore_preset_affiliate)
        {
            jQuery('.digistore_affiliation_status_hint').removeClass( 'digistore_affiliation_status_info' )
                                                        .removeClass( 'digistore_affiliation_status_error' )
                                                        .removeClass( 'digistore_affiliation_status_success' );
        }
        else
        {
            if (status != 'wait_for_approval')
            {
                add_msg =  jQuery('#$singup_msg_span_id').html();

                if (typeof add_msg != 'undefined') {
                    msg += add_msg;
                }
            }
            jQuery('.digistore_affiliation_status_hint').removeClass( 'digistore_affiliation_status_info' )
                                                        .removeClass( 'digistore_affiliation_status_success' )
                                                        .addClass( 'digistore_affiliation_status_error' )
                                                        .html( msg );
        }
    }
    catch (e)
    {
    }
}

jQuery(document).ready( function() {
    jQuery( '.digistore_focus' ).focus( function() { this.select(); });
    jQuery( '.digistore_focus' ).click( function() { this.select(); });
    jQuery( '.digistore_focus' ).keyup( function() { this.select(); });
    jQuery( '.digistore_focus' ).mouseup( function() { this.select(); });
});

";
        }

        $js_preset_affiliate = '';

        $preset_affiliate = $this->_getPresetGeneratorAffiliate();

        if ($preset_affiliate) {
            $js_preset_affiliate = "digistore_set_affiliate( \"$preset_affiliate\", true );";
        }

        $js .=
            "jQuery(document).ready( function() {

    var input = jQuery('#$html_id');

    var affiliate = input.val();
    if (affiliate) {
        digistore_set_affiliate( affiliate, false );
    }

    input.keyup( function() {
        var affiliate=jQuery(this).val();
        digistore_set_affiliate( affiliate, false );
    });

    $js_preset_affiliate

});
";

        $js = '<script type="text/javascript">'.$this->minifyJs($js).'</script>';

        $html .= '<style>.digistore_rendered_code { word-wrap: normal; }</style>';

        if ($signup_hint) {
            $html .= "<table class=\"{$prefix}_generator\">
<tr class=\"{$prefix}_generator_id_row\">
    <td class=\"{$prefix}_label\">$label_digistore_id</td>
    <td class=\"{$prefix}_input\">$input_digistore_id</td>
</tr>
<tr class=\"digistore_hint_row\">
    <td></td>
    <td class='digistore_affiliation_status_hint digistore_affiliation_status_info'>$signup_hint</td>
</tr>";

            if ($promolink) {
                $html .= "
        <tr class=\"{$prefix}_generator_link_row\">
            <td class=\"{$prefix}_label\">$label_promolink</td>
            <td class=\"{$prefix}_input\">$input_promolink</td>
        </tr>";
            }

            $html .= '
    </table>';
        } else {
            $html = "<span style='white-space: nowrap;'>$label_digistore_id $input_digistore_id</span>";
        }

        return $this->minifyHtml($html).$js;
    }

    /**
     * Renders social proof widget
     * Called via ds_socialproof shortcode
     *
     * @psalm-used-by ds_socialproof (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderSocalproof($attributes = [])
    {
        $id = $this->retrieve($attributes, 'id');
        $key = $this->retrieve($attributes, 'key');
        $height = $this->retrieve($attributes, 'height');
        $width = $this->retrieve($attributes, 'width');
        $type = $this->retrieve($attributes, 'type', 'iframe');
        $lang = $this->retrieve($attributes, 'lang');

        if (!$id) {
            return 'ERROR ds_socialproof: argument id missing';
        }
        if (!$key) {
            return 'ERROR ds_socialproof: argument key missing';
        }
        if (!$height) {
            return 'ERROR ds_socialproof: argument height missing';
        }
        if (!$width) {
            return 'ERROR ds_socialproof: argument width missing';
        }

        $base_url = $this->getBaseUrl();

        $is_dropin = 'dropin' == $type;

        $url = "$base_url/socialproof/$id/$key/$height/$width";

        if ($lang && 'XX' != $lang) {
            $url .= "/$lang";
        }

        if ($is_dropin) {
            $html = "<script src=\"$url.js\" defer></script>";
        } else {
            $html = "<iframe src=\"$url\" height=\"{$height}px\" width=\"{$width}px\" allowtransparency='true' scrolling='no' frameborder='0'></iframe>";
        }

        return $html;
    }

    /**
     * Renders order form widget
     * Called via ds_orderform shortcode
     *
     * @psalm-used-by ds_orderform (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderOrderform($attributes = [])
    {
        $id = $this->retrieve($attributes, 'id');
        $product = $this->retrieve($attributes, 'product');
        $width = $this->retrieve($attributes, 'width', 0);
        $baseurl = rtrim($this->retrieve($attributes, 'baseurl', $this->getBaseUrl()), '/ ');

        unset($attributes['id']);
        unset($attributes['product']);
        unset($attributes['width']);

        $attributes['is_in_iframe'] = 1;

        if (!$id) {
            return 'ERROR ds_orderform: argument id missing';
        }
        if (!$product) {
            return 'ERROR ds_orderform: argument product missing';
        }

        $width = intval($width);
        if ($width >= 100 && $width <= 10000) {
            $css_width = ''.$width.'px';
        } else {
            $css_width = '100%';
        }

        $args = [];
        foreach ($attributes as $k => $v) {
            // $args .= $args? '&' : '?';

            $args[] = $this->washText($k).'='.$this->washText($v);
        }

        wp_enqueue_script('digistore');

        return '<my-order-form product-id="'.$product.'"'.
            ' order-form-id="'.$id.'" width="'.$css_width.'"'.
            ' base-url="'.$baseurl.'"'.
            (empty($args) ? '' : ' query="'.implode('&', $args).'"').'></my-order-form>';
    }

    /**
     * Renders countdown widget
     * Called via ds_countdown shortcode
     *
     * @psalm-used-by ds_countdown (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderCountdown($attributes = [])
    {
        $id = $this->retrieve($attributes, 'id');
        $key = $this->retrieve($attributes, 'key');

        if (!$id) {
            return 'ERROR ds_countdown: argument id missing';
        }
        if (!$key) {
            return 'ERROR ds_countdown: argument key missing';
        }

        $base_url = $this->getBaseUrl();

        $url = "$base_url/countdown/$id/$key.js";

        $html = "<div><script src=\"$url\"></script></div>";

        return $html;
    }

    public function getJsPromoCode()
    {
        if ($this->tracking_code_rendered) {
            return;
        }

        $this->tracking_code_rendered = true;

        if ($this->mustHideTrackingCode()) {
            return;
        }

        $options = $this->getAdminOptions();

        $get_param_affiliate = $options['get_param_affiliate'];
        $get_param_campaignkey = $options['get_param_campaignkey'];

        $product_id = $this->getFirstProductId();

        $promocodeParameter = [
            'product_id' => $product_id,
        ];
        if (!empty($get_param_affiliate)) {
            $promocodeParameter['affiliate_key'] = $get_param_affiliate;
        }
        if (!empty($get_param_campaignkey)) {
            $promocodeParameter['campaignkey_key'] = $get_param_campaignkey;
        }

        /**
         * Filters the JavaScript callback functions to be executed when an affiliate is detected.
         *
         * @param array $js_callback_list Array of callback function names (strings) to be called in the frontend.
         */
        $js_callback_list = apply_filters('ds24_js_callback_affiliate_detected', []);
        if ($js_callback_list) {
            $callback_js = 'function( a, c ) { var f; ';
            foreach ($js_callback_list as $one) {
                $callback_js .= "f=$one; f(a,c);";
            }
            $callback_js .= '}';
            $promocodeParameter['callback'] = $callback_js;
        }

        return '<script type="text/javascript">
            window._ds24 = !window._ds24 ? {q:[],e:function(){}} : window._ds24;
            window._ds24.q.push([\'digistorePromocode\', '.json_encode($promocodeParameter).']);
            window._ds24.e();
        </script>';
    }

    private function detectAffiliateFromGetParams()
    {
        $options = $this->getAdminOptions();

        $get_param_affiliate = $options['get_param_affiliate'];
        $get_param_campaignkey = $options['get_param_campaignkey'];

        $affiliate = $this->requestvar($get_param_affiliate);

        if (!$affiliate && !empty($_COOKIE['ds24_aff'])) {
            $affiliate = $_COOKIE['ds24_aff'];
            $campaignkey = empty($_COOKIE['ds24_cam'])
                ? ''
                : $_COOKIE['ds24_cam'];
        } elseif ($affiliate) {
            $campaignkey = $this->requestvar($get_param_campaignkey);

            do_action('ds24_php_affiliate_detected', $affiliate, $campaignkey);
        } else {
            [$affiliate, $campaignkey] = apply_filters('ds24_affiliate_and_campaignkey', ['', '']);
        }

        $this->affiliate = $affiliate;
        $this->campaignkey = $campaignkey;

        if ($affiliate) {
            setcookie('ds24_aff', $affiliate, 0, '/');
            setcookie('ds24_cam', $campaignkey, 0, '/');
        } else {
            setcookie('ds24_aff', '', time() - 86400, '/');
            setcookie('ds24_cam', '', time() - 86400, '/');
        }
    }

    private function mustHideTrackingCode()
    {
        $is_ajax = (defined('DOING_AJAX') && DOING_AJAX)
            || (defined('NCORE_IS_AJAX') && NCORE_IS_AJAX);
        if ($is_ajax) {
            return true;
        }

        $is_ipn = defined('NCORE_IS_IPN') && NCORE_IS_IPN;
        if ($is_ipn) {
            return true;
        }

        return false;
    }

    private function requestvar($key, $default = '')
    {
        $value = $this->retrieve($_REQUEST, $key, $default);

        if ($key === $this->postname('product_id')) {
            $value = $this->sanitizeProductIds($value);
        }

        return $value;
    }

    private function sanitizeProductIds($value)
    {
        $posted_ids = explode(',', str_replace([' ', ';', ',', '-'], ',', $value));
        $result_ids = [];

        foreach ($posted_ids as $id) {
            if (is_numeric($id) && $id && !in_array($id, $result_ids)) {
                $result_ids[] = $id;
            }
        }
        $value = implode(',', $result_ids);

        return $value;
    }

    private function retrieve($array, $key_or_keys, $default = '')
    {
        $keys = is_array($key_or_keys)
            ? $key_or_keys
            : [$key_or_keys];

        foreach ($keys as $key) {
            if (isset($array[$key])) {
                return $array[$key];
            }
        }

        return $default;
    }

    private function adminOptionDefaults()
    {
        $defaults = [
            'get_param_affiliate' => $this->get_param_affiliate,
            'get_param_campaignkey' => $this->get_param_campaignkey,
            'product_id' => $this->product_id,
            'thankyou_page_key' => $this->thankyou_page_key,
            'custom_domain' => '',
        ];

        return $defaults;
    }

    private function adminOptionLabels()
    {
        $labels = [
            'get_param_affiliate' => $this->_('Affiliate Get Parameter'),
            'get_param_campaignkey' => $this->_('Campaignkey Get Parameter'),
            'product_id' => $this->_('Product id'),
            'thankyou_page_key' => $this->_('Thankyou page key'),
        ];

        return $labels;
    }

    private function adminOptionHint($key)
    {
        $hints = [
            'get_param_affiliate' => '',
            'get_param_campaignkey' => '',
            'product_id' => $this->_('Seperate multiple product ids by comma. Only the first id is used for the affiliate link. All of the ids are used for the [OWNER] signup link.'),
            'thankyou_page_key' => $this->_('See in [OWNER], under Account - Settings, there below Thank you page settings'),
        ];

        $hint = $this->retrieve($hints, $key);

        return $hint;
    }

    private function getAdminOptions()
    {
        $defaults = $this->adminOptionDefaults();

        $stored_options = get_option($this->admin_option_name);

        $options = $defaults;

        foreach (array_keys($defaults) as $key) {
            if (isset($stored_options[$key])) {
                $options[$key] = $stored_options[$key];
            }
        }

        return $options;
    }

    private function storeAdminOptions($options_to_store)
    {
        $defaults = $this->adminOptionDefaults();

        $values = [];

        /** @var string $key */
        foreach (array_keys($defaults) as $key) {
            if (isset($options_to_store[$key])) {
                $values[$key] = $options_to_store[$key];
            }
        }

        update_option($this->admin_option_name, $values);
    }

    private function washUrl($text)
    {
        $forbidden_chars = [
            ' ',
            '\\',
            '\r',
            '\n',
            '\t',
            ';',
            '....',
            '...',
            '..',
            '"',
            "'",
        ];

        return str_replace($forbidden_chars, '', trim($text));
    }

    private function washText($text)
    {
        $forbidden_chars = [
            '#',
            '%',
            '&',
            '/',
        ];

        return str_replace($forbidden_chars, '', trim($this->washUrl($text)));
    }

    private function postname($key)
    {
        return "digistore_$key";
    }

    private function _get_thankyoupage_key()
    {
        static $thankyou_page_key;
        if (!isset($thankyou_page_key)) {
            if (!defined('DS24_ARRAY_ENCRYPTPTION_VALIDATION_PREFIX')) {
                require_once dirname(__FILE__).'/encryption_helper.php';
            }

            $options = $this->getAdminOptions();
            $thankyou_page_key = $options['thankyou_page_key'];
        }

        return $thankyou_page_key;
    }

    private function _get_param($key, $default = '')
    {
        static $get;
        static $have_warned;
        if (!isset($get)) {
            $thankyou_page_key = $this->_get_thankyoupage_key();
            if ($thankyou_page_key) {
                $get = digistore_decrypt_url_args($thankyou_page_key, $_GET);
            } else {
                $get = [];

                if (empty($have_warned)) {
                    $have_warned = true;

                    return $this->_('ERROR: Please enter %s thank you page key under Settings - %s', 'Digistore24', 'Digistore24');
                }
            }
        }

        $value = $this->retrieve($get, $key, $default);

        $is_error = false === $value;
        if ($is_error) {
            if (empty($have_warned)) {
                $have_warned = true;

                return $this->_('ERROR: The %s thank you page key under Settings - %s seems to be incorrect. Or the URL get params are manipulated. Please check!', 'Digistore24', 'Digistore24');
            }

            return false;
        }

        return $value;
    }

    private function hasPromoCode()
    {
        return !$this->mustHideTrackingCode();
    }

    private function upsellSessionId()
    {
        if (false === $this->upsell_session_id) {
            $this->upsell_session_id = '';

            if (!$this->upsell_session_id && isset($_POST['digistore_upsell_session_id'])) {
                $this->upsell_session_id = $_POST['digistore_upsell_session_id'];
            }

            if (!$this->upsell_session_id && isset($_GET['digistore_upsell_session_id'])) {
                $this->upsell_session_id = $_GET['digistore_upsell_session_id'];
            }

            if (!$this->upsell_session_id && isset($_GET['digistore'])) {
                $this->upsell_session_id = $_GET['digistore'];
            }

            if (!$this->upsell_session_id && isset($_COOKIE['digistore_upsell_session_id'])) {
                $this->upsell_session_id = $_COOKIE['digistore_upsell_session_id'];
            }

            if ($this->upsell_session_id) {
                setcookie('digistore_upsell_session_id', $this->upsell_session_id, 0, '/');
            }
        }

        if (false === $this->upsell_first_name) {
            $this->upsell_first_name = '';
            $this->upsell_last_name = '';

            if (!$this->upsell_first_name && !empty($_POST['digistore_first_name'])) {
                $this->upsell_first_name = $_POST['digistore_first_name'];
            }
            if (!$this->upsell_first_name && !empty($_GET['digistore_first_name'])) {
                $this->upsell_last_name = $this->_get_param(self::GET_PARAM_FIRST_NAME);
            }
            if (!$this->upsell_first_name && !empty($_COOKIE['digistore_first_name'])) {
                $this->upsell_first_name = $_COOKIE['digistore_first_name'];
            }

            if ($this->upsell_first_name) {
                setcookie('digistore_first_name', $this->upsell_first_name, 0, '/');
            }

            if (!$this->upsell_last_name && !empty($_POST['digistore_last_name'])) {
                $this->upsell_last_name = $_POST['digistore_last_name'];
            }
            if (!$this->upsell_last_name) {
                $this->upsell_last_name = $this->_get_param(self::GET_PARAM_LAST_NAME);
            }
            if (!$this->upsell_last_name && !empty($_COOKIE['digistore_last_name'])) {
                $this->upsell_last_name = $_COOKIE['digistore_last_name'];
            }

            if ($this->upsell_last_name) {
                setcookie('digistore_last_name', $this->upsell_last_name, 0, '/');
            }

            if (!$this->upsell_email && !empty($_POST['digistore_email'])) {
                $this->upsell_email = $_POST['digistore_email'];
            }
            if (!$this->upsell_email) {
                $this->upsell_email = $this->_get_param(self::GET_PARAM_EMAIL);
            }
            if (!$this->upsell_email && !empty($_COOKIE['digistore_email'])) {
                $this->upsell_email = $_COOKIE['digistore_email'];
            }

            if ($this->upsell_email) {
                setcookie('digistore_email', $this->upsell_email, 0, '/');
            }

            if (!$this->upsell_initial_product_id && isset($_POST['digistore_initial_product_id'])) {
                $this->upsell_initial_product_id = $_POST['digistore_initial_product_id'];
            }
            if (!$this->upsell_initial_product_id && isset($_GET['digistore_initial_product_id'])) {
                $this->upsell_initial_product_id = $_GET['digistore_initial_product_id'];
            }
            if (!$this->upsell_initial_product_id && isset($_COOKIE['digistore_initial_product_id'])) {
                $this->upsell_initial_product_id = $_COOKIE['digistore_initial_product_id'];
            }

            if ($this->upsell_initial_product_id) {
                setcookie('digistore_initial_product_id', $this->upsell_initial_product_id, 0, '/');
            }
        }

        return $this->upsell_session_id;
    }

    private function maybeAddUpsellSessionId($content)
    {
        $session_id = $this->upsellSessionId();
        if (!$session_id) {
            return $content;
        }

        wp_enqueue_script('digistore');

        $first_name = $this->upsell_first_name;
        $last_name = $this->upsell_last_name;

        $hidden_input = "<input type='hidden' name='digistore_upsell_session_id' value='$session_id' />"
            ."<input type='hidden' name='digistore_upsell_first_name' value=\"$first_name\" />"
            ."<input type='hidden' name='digistore_upsell_last_name'  value=\"$last_name\" />";

        $find = [];
        $repl = [];

        $find[] = '</form>';
        $repl[] = "$hidden_input</form>";

        $find[] = '[DIGISTORE_UPSELL_SESSION_ID]';
        $repl[] = "digistore_upsell_session_id=$session_id";

        $upsell_url = $this->getUpsellUrl();
        $length = strlen($upsell_url);
        $pos = strpos($content, $upsell_url);
        while (false !== $pos) {
            $start = $pos;
            $pos += $length;
            $posS = strpos($content, "'", $pos);
            $posD = strpos($content, '"', $pos);

            $pos = false === $posS
                ? $posD
                : (false === $posD
                    ? $posS
                    : min($posS, $posD));

            if (false === $pos) {
                break;
            }

            $quote = substr($content, $pos, 1);

            $url = substr($content, $start, $pos - $start);

            $have_id = str_contains($url, '[DIGISTORE_UPSELL_SESSION_ID]');

            if (!$have_id) {
                if (!in_array($quote.$url.$quote, $find)) {
                    $find[] = $quote.$url.$quote;
                    $repl[] = $quote.$this->_append_upsell_id($url, $session_id).$quote;
                }
            }

            $pos = strpos($content, $upsell_url, $pos + 1);
        }

        $content = str_replace($find, $repl, $content);

        return $content;
    }

    private function _append_upsell_id($url, $session_id)
    {
        $pos = strpos($url, '#');
        $have_anchor = false !== $pos;

        $base_url = $have_anchor ? substr($url, 0, $pos - 1) : $url;
        $have_question_mark = str_contains($base_url, '?');

        $base_url .= ($have_question_mark ? '&' : '?');

        $base_url .= 'digistore_upsell_session_id='.$session_id;

        if ($have_anchor) {
            $base_url .= '#'.substr($url, $pos + 1);
        }

        return $base_url;
    }

    private function renderGeneralExplanation()
    {
        $html = '<p>'.$this->_('This plugin has three functions:').'</p>';
        $html .= '<p>'.$this->_('1. It makes it easy to reward affiliates, who send visitors to you blog, by adding a tracking pixel.').'</p>';
        $html .= '<p>'.$this->_('2. It makes upsells with [OWNER] and wordpress very easy.').'</p>';
        $html .= '<p>'.sprintf($this->_('3. It provides an affiliate link generator. The user enters his %s id and gets the promolink for your product.'), 'Digistore24').'</p>';

        return $html;
    }

    private function renderCustomDomainExplanation()
    {
        $html = '<p>'.$this->_('Please enter the custom domain to be used with [OWNER] and wordpress.').'</p>';
        $html .= '<p>'.$this->_('Leave blank in case you don\'t use a custom domain to sell your products via [OWNER]').'</p>';

        return $html;
    }

    private function renderPromocodeExplanation()
    {
        $options = $this->getAdminOptions();

        $html = '';

        $html .= '<p><strong>'.$this->_('Important: Please test your tracking! Now and after every major change (like updates, new plugins, ...). Because other Wordpress plugins, your Wordpress theme or any redirect may interfere with the tracking. Make a test purchase and validate, that the affiliates name is displayed at the bottom of the order form. If in doubt, use the default promolink like %s.', DIGISTORE_BLOG_BASE_LINK.'?'.$options['get_param_affiliate'].'=AFFILIATE&'.$options['get_param_campaignkey'].'=CAMPAIGNKEY').'</strong></p>';

        $html .= '<p>'.$this->_('The tracking cookie is required to reward your affiliates, who send visitors to you blog, for their sales.').'</p>';

        $html .= '<p>'.$this->_('To prevent fraud, you need to register your blog domain within [OWNER].').'</p>';

        $html .= '<p>'.$this->_('You need to enter just one product id - even you if multiple products. The affiliate will get his provision for any product you automatically accept affilations for (which is the default).').'</p>';

        $example_url = site_url().'/#'.$options['get_param_affiliate'].'='.AFFVAR.'&'.$options['get_param_campaignkey'].'=CAMPAIGNKEY';

        $example_link = "<a href='$example_url'>$example_url</a>";

        $html .= '<p>'.$this->_('The affiliate links to your blog using the url:').'</p>';

        $html .= "<p>$example_link</p>";

        $html .= '<p>'.$this->_('The affiliate replaces %s by his [OWNER_ID].', AFFVAR).'</p>';

        $html .= '<p>'.$this->_('The parameter CAMPAIGNKEY is optional - the affiliate may use it to track his own campaigns.').'</p>';

        $html .= '<p>'.$this->_('In the url the parameters are seperated by #, not by ? (this improves your seo ranking.)').'</p>';

        return $html;
    }

    private function renderUpsellExplanation()
    {
        $html = '<p>'.$this->_('To use upsells with [OWNER] and wordpress, first setup the upsells in [OWNER].').'</p>';

        $html .= '<p>'
            .sprintf($this->_('Here in wordpress, create an upsell salespage. Use the shortcodes %s and %s, which are replaced by urls targeting back to [OWNER].'), '<span class="digistore_shortcode">[digistore_yes_url]</span>', '<span class="digistore_shortcode">[digistore_no_url]</span>')
            .'</p>';

        $html .= '<p>'.$this->_('Use these shortcodes as urls in your links, like in this example html code:').'</p>';

        $code = $this->renderUpsellExampleCode();
        $html .= "<pre>$code</pre>";

        $html .= '<p>'.$this->_('When the user clicks the yes link or the no link, he is redirected back to [OWNER], where the next upsell step depending your upsell settings and the user\'s choice is performed.').'</p>';

        $html .= '<p>'.$this->_('If you are using multiple upsell products, it is required to pass attributes to your shortcode:').'</p>';
        $code = $this->renderUpsellExampleCodeWithParameters();
        $html .= "<pre>$code</pre>";
        $html .= '<p>'.$this->_('Replace the parameters (<YOUR_...>) with the values provided from your Dashboard.').'</p>';
        $html .= '<p>'.$this->_('You can use one of the following parameters:').' <span style="font-family: monospace;">'.implode(', ', self::ALLOWED_YES_QUERY_PARAMS).'</span>.</p>';

        $html .= '<h4>'.$this->_('Hints').'</h4>';

        $html .= '<p>'.$this->_(' If wordpress fails to generated the correct link, try using %s resp. %s instead.', '<span class="digistore_shortcode"><strong>https://</strong>[digistore_yes_url]</span>', '<span class="digistore_shortcode"><strong>https://</strong>[digistore_no_url]</span>').'</p>';

        $html .= '<p>'.$this->_('If you test the upsell links <strong>outside</strong> an upsell process, you will get error messages (page not find). Try testing the complete upsell funnel using test payments.').'</p>';

        $html .= '<p>'.$this->_('If the users leaves the upsell salespage (and does not click on the yes or no link), then he looses the upsell oportunity.').'</p>';

        $html .= '<h3>'.$this->_('Addressing the customer').'</h3>';

        $shortcode_1 = '<strong>[digistore_first_name]</strong>';
        $shortcode_2 = '<strong>[digistore_last_name]</strong>';
        $html .= '<p>'.$this->_('If you want to address the customer in a personal fashion, use the shortcodes %s and %s, e.g.:', $shortcode_1, $shortcode_2).'</p>';

        $html .= '<p><em>'.$this->_('Hello %s %s! Thanks for buying our product!', $shortcode_1, $shortcode_2).'</em></p>';

        return $html;
    }

    private function renderUpsellExampleCode()
    {
        $txt_question = $this->_('Do you want to by the product?');
        $txt_yes = $this->_('Yes, please');
        $txt_no = $this->_('No, thank you');

        $code = "
<p>
    $txt_question
</p>

<p>
    <a href=\"[digistore_yes_url]\">$txt_yes</a>
</p>

<p>
    <a href=\"[digistore_no_url]\">$txt_no</a>
</p>
";

        return htmlspecialchars($code);
    }

    private function renderUpsellExampleCodeWithParameters()
    {
        $txt_yes = $this->_('Yes, please');
        $txt_no = $this->_('No, thank you');
        $code = "<p>
    <a href=\"[digistore_yes_url product=<YOUR_PRODUCT_ID>]\">$txt_yes</a>
    <a href=\"[digistore_yes_url qty=<YOUR_QUANTITY>]\">$txt_yes</a>
    <a href=\"[digistore_yes_url payplan=<YOUR_PAYPLAN_ID>]\">$txt_yes</a>
</p>
<p>
    <a href=\"[digistore_no_url]\">$txt_no</a>
</p>";

        return htmlspecialchars($code);
    }

    private function minifyHtml($html)
    {
        return str_replace(["\r\n", "\r", "\n"], ' ', $html);
    }

    private function minifyJs($js_code)
    {
        // Must "minify" code to work with templates, who add <p> for linebreaks
        // e.g. on digimember.de

        if (self::DEBUG) {
            return $js_code;
        }

        $js_code = str_replace(["\r\n", "\r", "\n"], "\n", trim($js_code));

        $lines = explode("\n", $js_code);
        $result = '';
        foreach ($lines as $line) {
            $result .= ' '.trim($line);
        }

        $result = trim($result, ';').';';

        return $result;
    }

    private function finallyParseShortcodes($content)
    {
        $have_short_code = str_contains($content, 'digistore');
        if (!$have_short_code) {
            return $content;
        }

        $find = [];
        $repl = [];

        $yes_url = $this->renderUpsellYesUrl();
        $no_url = $this->renderUpsellNoUrl();
        $upsell_url = $this->renderUpsellUrl();

        $find[] = '[digistore_upsell_url]';
        $repl[] = $upsell_url;

        $find[] = '[digistore_yes_url]';
        $repl[] = $yes_url;

        $find[] = 'digistore_no_url]';
        $repl[] = $no_url;

        $find[] = 'http://[digistore_upsell_url]';
        $repl[] = $upsell_url;

        $find[] = 'https://'.$upsell_url;
        $repl[] = $upsell_url;

        $find[] = 'http://'.$upsell_url;
        $repl[] = $upsell_url;

        $find[] = '[digistore_affiliate]';
        $repl[] = $this->affiliate;

        $find[] = '[digistore_campaignkey]';
        $repl[] = $this->campaignkey;

        return str_replace($find, $repl, $content);
    }

    /**
     * Enqueues DigiStore CSS styles
     * Called via WordPress init hook
     *
     * @psalm-used-by init (WordPress hook)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function enqueueStyles()
    {
        $url = plugins_url('digistore/digistore.css', 'digistore');

        wp_enqueue_style('digistore', $url);
    }

    private function getFirstProductId()
    {
        $options = $this->getAdminOptions();

        $product_ids = explode(',', $options['product_id']);

        return $product_ids[0];
    }

    private function _($msg, $arg1 = '', $arg2 = '', $arg3 = '')
    {
        $msg = __($msg, 'digistore');

        $find = ['[OWNER]', '[OWNER_ID]'];
        $repl = ['Digistore24', 'Digistore24-Id'];

        $msg = str_replace($find, $repl, $msg);

        $msg = sprintf($msg, $arg1, $arg2, $arg3);

        return $msg;
    }

    private function preparePromoHtmlCode($atttributes, $content)
    {
        $content = $this->sanitizeQuotes($content);

        $keep_p_and_br = $this->parse_bool($this->retrieve($atttributes, 'keep_p_and_br', 'off'));
        if (!$keep_p_and_br) {
            $find = ['<p>', '</p>', '<br>', '<br />'];
            $repl = '';
            $content = str_replace($find, $repl, $content);
        }

        $enabled = $this->parse_bool($this->retrieve($atttributes, 'encode', 'on'));
        if ($enabled) {
            $content = htmlspecialchars($content);
        }

        [$w, $h] = $this->parse_size($this->retrieve($atttributes, 'textarea', 'off'), 40, 4);
        $have_textarea = $h >= 1;

        $autop_mode = $have_textarea
            ? 'text'
            : 'html';

        $enabled = $this->parse_bool($this->retrieve($atttributes, 'autop', 'true'));
        if ($enabled) {
            $content = $this->autop($content, $autop_mode);
        }

        if ($have_textarea) {
            $content = "<textarea class='digistore_code' rows='$h' cols='$w' readonly='readonly'>$content</textarea>";
        }

        $content = $this->minifyHtml($content);

        return $content;
    }

    private function purgeQuotes($content)
    {
        return $this->sanitizeQuotes($content, '', '');
    }

    private function sanitizeQuotes($content, $replace_single_quotes_by = "'", $replace_double_quotes_by = '"')
    {
        $content = html_entity_decode($content);

        $single_quotes = ['‘', '&lsquo;', '&#8216;', '&#x2018;',
            '’', '&rsquo;', '&#8217;', '&#x2019;',
            '‚', '&sbquo;', '&#8218;', '&#x201A;',
            '′', '&prime;', '&#8242;', '&#x2032;',

            '&lsaquo;', '&rsaquo;',
        ];

        $double_quotes = ['“', '&ldquo;', '&#8220;', '&#x201C;',
            '”', '&rdquo;', '&#8221;', '&#x201D;',
            '„', '&bdquo;', '&#8222;', '&#x201E;',
            '″', '&Prime;', '&#8243;', '&#x2033;',

            '&laquo;', '&raquo;',
        ];

        $content = str_replace($single_quotes, $replace_single_quotes_by, $content);
        $content = str_replace($double_quotes, $replace_double_quotes_by, $content);

        return $content;
    }

    public function parse_size($str, $default_w, $default_h)
    {
        $lower = strtolower($str);
        $tokens = explode('x', $lower);

        $have_size = count($tokens) >= 2
            && is_numeric($tokens[0])
            && is_numeric($tokens[1])
            && $tokens[0] >= 1
            && $tokens[1] >= 1;

        if ($have_size) {
            $w = intval($tokens[0]);
            $h = intval($tokens[1]);

            return [$w, $h];
        }

        $enabled = $this->parse_bool($str);
        if ($enabled) {
            return [$default_w, $default_h];
        }

        return [false, false];
    }

    private function parse_bool($str)
    {
        $lower = strtolower($str);
        if ('true' === $lower
            || 'on' === $lower
            || '1' === $str
            || 1 === $str
            || true === $str) {
            return true;
        }

        if ('false' === $lower
            || 'off' === $lower
            || '0' === $str
            || 0 === $str
            || false === $str) {
            return false;
        }

        return (bool) $str;
    }

    private function autop($content, $mode = 'html')
    {
        if ('text' == $mode) {
            $pstart = '';
            $pend = "\n\n";
            $lb = "\n";
        } else {
            $pstart = '<p>';
            $pend = '</p>';
            $lb = '<br />';
        }

        $lines = explode("\n", $content);

        $paragraphs = [];
        $index = 0;
        foreach ($lines as $line) {
            $line = trim($line);

            if ($line) {
                $paragraphs[$index][] = $line;
            } else {
                ++$index;
            }
        }

        $have_ps = count($paragraphs) >= 2;
        $html = '';
        foreach ($paragraphs as $lines) {
            $p = implode($lb, $lines);
            if (!$p) {
                continue;
            }

            if ($have_ps) {
                $html .= "$pstart$p$pend";
            } else {
                $html = $p;
            }
        }

        $html = trim($html);

        return $html;
    }

    private function _signUpUrl()
    {
        $options = $this->getAdminOptions();

        $product_ids = $options['product_id'];

        $second_level_affiliate = apply_filters('ds24_second_level_affiliate', '');

        $signup_link = trim('https://www.digistore24.com', '/')."/signup/$product_ids/$second_level_affiliate";

        return $signup_link;
    }

    private function _getPresetGeneratorAffiliate()
    {
        $preset_affiliate = empty($_GET['affiliate'])
            ? ''
            : $_GET['affiliate'];

        $preset_affiliate = apply_filters('ds24_affiliate_for_link_generator', $preset_affiliate);

        $preset_affiliate = str_replace(['&', "'", '"', ';'], '', $preset_affiliate);

        return $preset_affiliate;
    }

    /**
     * Renders upsell button component
     * Called via digistore_upsell_button shortcode
     *
     * @psalm-used-by digistore_upsell_button (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderUpsellButton($args = [])
    {
        $templateAttrValue = $args['theme'] ?? $args['template'] ?? '';
        $templateAttr = sprintf('template="%s"', $templateAttrValue);

        return "<digistore-upsell-button $templateAttr></digistore-upsell-button>";
    }

    /**
     * Renders upsell button radio component
     * Called via digistore_upsell_button_radio shortcode
     *
     * @psalm-used-by digistore_upsell_button_radio (WordPress shortcode)
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function renderUpsellButtonRadio($args = [])
    {
        $classAttr = sprintf('class="%s"', $args['class'] ?? 'digistore-upsell-button-radio');
        $label = $args['label'] ?? '';

        $value = $args['value'] ?? '';
        if (!$value) {
            $label = '<span>
                        !!!! radio button value is missing but must be defined. !!!
                        <br>
                        Value follows structure: <i>{{upsellOptionType}}-{{upsellOptionValue}}</i> e.g. <b>value=product-56789</b>
                      </span>';
        }

        return '<label '.$classAttr.'>
            <input id="digistore-upsell-button-radio-'.$value.'" type="radio" name="digistore-upsell-button-radio" value="'.$value.'"/> '.$label.'
        </label>';
    }
}

$is_ajax = (defined('DOING_AJAX') && DOING_AJAX)
    || (defined('NCORE_IS_AJAX') && NCORE_IS_AJAX);
if (!$is_ajax) {
    $digistore_plugin = DigiStore::getInstance();

    $plugin_file = basename(__DIR__).'/'.basename(__FILE__);

    $is_admin = is_admin();

    add_action('init', [$digistore_plugin, 'enqueueStyles'], 10, 0);

    if ($is_admin) {
        add_action('admin_notices', [$digistore_plugin, 'validateConfig'], 10, 0);

        add_filter("plugin_action_links_$plugin_file", [
            $digistore_plugin,
            'addSettingsLink',
        ]);

        add_action('admin_menu', [
            $digistore_plugin,
            'admiMenu',
        ]);
    }

    if (!$is_admin) {
        add_filter('the_content', [
            $digistore_plugin,
            'contentFilter',
        ], PHP_INT_MAX);

        // add_filter( 'shutdown', array(
        //      $digistore_plugin,
        //     'printPromoCode'  ) );

        add_action('wp_enqueue_scripts', [$digistore_plugin, 'initScripts'], 10, 0);

        add_shortcode('digistore_promolink', [
            $digistore_plugin,
            'renderPromoLinkGenerator',
        ]);

        add_shortcode('digistore_promolink_code', [
            $digistore_plugin,
            'renderPromoLinkCode',
        ]);

        add_shortcode('digistore_bloglink', [
            $digistore_plugin,
            'renderBlogLinkGenerator',
        ]);

        add_shortcode('digistore_yes_url', [
            $digistore_plugin,
            'renderUpsellYesUrl',
        ]);

        add_shortcode('digistore_no_url', [
            $digistore_plugin,
            'renderUpsellNoUrl',
        ]);

        add_shortcode('digistore_upsell_url', [
            $digistore_plugin,
            'renderUpsellUrl',
        ]);

        add_shortcode('digistore_first_name', [
            $digistore_plugin,
            'renderUpsellFirstName',
        ]);

        add_shortcode('digistore_last_name', [
            $digistore_plugin,
            'renderUpsellLastName',
        ]);

        add_shortcode('digistore_email', [
            $digistore_plugin,
            'renderUpsellEmail',
        ]);

        add_shortcode('digistore', [
            $digistore_plugin,
            'renderData',
        ]);
        add_shortcode('digistore_initial_product_id', [
            $digistore_plugin,
            'renderUpsellInitialProductId',
        ]);

        add_shortcode('digistore_signup_url', [
            $digistore_plugin,
            'renderSignupUrl',
        ]);

        add_shortcode('digistore_affiliate', [
            $digistore_plugin,
            'renderAffiliate',
        ]);

        add_shortcode('digistore_campaignkey', [
            $digistore_plugin,
            'renderCampaignkey',
        ]);

        add_shortcode('ds_socialproof', [
            $digistore_plugin,
            'renderSocalproof',
        ]);

        add_shortcode('ds_orderform', [
            $digistore_plugin,
            'renderOrderform',
        ]);

        add_shortcode('ds_countdown', [
            $digistore_plugin,
            'renderCountdown',
        ]);

        add_shortcode('digistore_cart', [
            $digistore_plugin,
            'renderDigistoreCartJs',
        ]);

        add_shortcode('digistore_cart_checkout', [
            $digistore_plugin,
            'renderDigistoreCartCheckout',
        ]);

        //
        // Legacy short codes
        //
        add_shortcode('digistore_promolink_input', [
            $digistore_plugin,
            'renderPromoLinkInput',
        ]);

        add_shortcode('digistore_bloglink_input', [
            $digistore_plugin,
            'renderBlogLinkInput',
        ]);

        add_shortcode('digistore_upsell_button', [
            $digistore_plugin,
            'renderUpsellButton',
        ]);

        add_shortcode('digistore_upsell_button_radio', [
            $digistore_plugin,
            'renderUpsellButtonRadio',
        ]);
    }

    $plugin_dir = dirname($plugin_file);

    load_plugin_textdomain('digistore', false, $plugin_dir);

    require 'ncore_update_checker.php';
    ncore_WpPluginUpdateChecker::init('Digistore24', $plugin_file, 'https://www.digistore24.com/api/wordpress');
}

/**
 * Excludes DigiStore JavaScript from Autoptimize optimization
 * Called via autoptimize_filter_js_exclude hook
 *
 * @psalm-suppress HookNotFound
 * hook is added via 3rd party plugin: https://github.com/wp-plugins/autoptimize
 * @psalm-used-by autoptimize_filter_js_exclude (WordPress hook)
 */
add_filter('autoptimize_filter_js_exclude', '_ds24wp_ao_jsexclude', 10, 1);
/**
 * @psalm-used-by autoptimize_filter_js_exclude (WordPress hook)
 * @psalm-suppress PossiblyUnusedMethod
 */
function _ds24wp_ao_jsexclude($exclude)
{
    return $exclude.', digistorePromocode, digistoreCart, digistore_set_affiliate';
}
